/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.game;

import java.net.URL;
import java.nio.file.Path;
import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.impl.lib.sat4j.pb.SolverFactory;
import net.fabricmc.loader.impl.lib.sat4j.specs.ContradictionException;
import net.fabricmc.loader.impl.util.UrlConversionException;
import net.fabricmc.loader.impl.util.UrlUtil;
import net.fabricmc.mapping.tree.TinyMappingFactory;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.util.CheckClassAdapter;
import org.spongepowered.asm.launch.MixinBootstrap;

enum LoaderLibrary {
    FABRIC_LOADER(UrlUtil.LOADER_CODE_SOURCE),
    TINY_MAPPINGS_PARSER(TinyMappingFactory.class),
    SPONGE_MIXIN(MixinBootstrap.class),
    TINY_REMAPPER(TinyRemapper.class),
    ACCESS_WIDENER(AccessWidener.class),
    ASM(ClassReader.class),
    ASM_ANALYSIS(Analyzer.class),
    ASM_COMMONS(Remapper.class),
    ASM_TREE(ClassNode.class),
    ASM_UTIL(CheckClassAdapter.class),
    SAT4J_CORE(ContradictionException.class),
    SAT4J_PB(SolverFactory.class),
    SERVER_LAUNCH("fabric-server-launch.properties", EnvType.SERVER),
    SERVER_LAUNCHER("net/fabricmc/installer/ServerLauncher.class", EnvType.SERVER);

    final Path path;
    final EnvType env;

    private LoaderLibrary(Class<?> cls) {
        this(UrlUtil.getCodeSource(cls));
    }

    private LoaderLibrary(Path path) {
        if (path == null) {
            throw new RuntimeException("missing loader library " + this.name());
        }
        this.path = path;
        this.env = null;
    }

    private LoaderLibrary(String file, EnvType env) {
        URL url = LoaderLibrary.class.getClassLoader().getResource(file);
        try {
            this.path = url != null ? UrlUtil.getCodeSource(url, file) : null;
            this.env = env;
        }
        catch (UrlConversionException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isApplicable(EnvType env) {
        return this.env == null || this.env == env;
    }
}

